#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Fly by NightMod01.fsh   by  mhnewman
//https://www.shadertoy.com/view/XlXGD7
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract




//	My first contribution to Shadertoy
//	I have been a big fan of this community for a while and I want to thank iq for
//	this wonderful site.
//	Hash functions from David Hoskins via https://www.shadertoy.com/view/4djSRW

const mat2 m = mat2(1.616, 1.212, -1.212, 1.616);

float hash12(vec2 p) {
	p = fract(p * vec2(5.3983, 5.4427));
    p += dot(p.yx, p.xy + vec2(21.5351, 14.3137));
	return fract(p.x * p.y * 95.4337);
}

vec2 hash21(float p) {
	vec2 p2 = fract(p * vec2(5.3983, 5.4427));
    p2 += dot(p2.yx, p2.xy +  vec2(21.5351, 14.3137));
	return fract(vec2(p2.x * p2.y * 95.4337, p2.x * p2.y * 97.597));
}

float noise(in vec2 p) {
    vec2 i = floor(p);
    vec2 f = fract(p);
	vec2 u = f * f * (3.0 - 2.0 * f);

    return mix(mix(hash12(i + vec2(0.0, 0.0)), 
                   hash12(i + vec2(1.0, 0.0)), u.x),
               mix(hash12(i + vec2(0.0, 1.0)), 
                   hash12(i + vec2(1.0, 1.0)), u.x), u.y);
}

float hash12_3(vec2 p) {
	float f = hash12(p);
    return f * f * f;
}

float noise_3(in vec2 p) {
    vec2 i = floor(p);
    vec2 f = fract(p);
	vec2 u = f * f * (3.0 - 2.0 * f);

    return mix(mix(hash12_3(i + vec2(0.0, 0.0)), 
                   hash12_3(i + vec2(1.0, 0.0)), u.x),
               mix(hash12_3(i + vec2(0.0, 1.0)), 
                   hash12_3(i + vec2(1.0, 1.0)), u.x), u.y);
}

float fbm(vec2 p) {
    float f = 0.0;
    f += 0.5 * noise(p); p = m * p;
    f += 0.25 * noise(p); p = m * p;
    f += 0.125 * noise(p); p = m * p;
    f += 0.0625 * noise(p); p = m * p;
    f += 0.03125 * noise(p); p = m * p;
    f += 0.015625 * noise(p);
    return f / 0.984375;
}

vec3 getDir(vec2 screenPos) {
    screenPos -= 0.5;
	screenPos.x *= iResolution.x / iResolution.y;
    
    return normalize(vec3(0.0, -1.0, -3.0)
                     + screenPos.x * vec3(1.0, 0.0, 0.0)
                     - screenPos.y * vec3(0.0, -0.948683298, 0.316227766));
}

bool getPosition(in vec3 camera, in vec3 dir, out vec2 pos) {
    bool valid = false;
    
	float b = dot(camera, dir);
	float c = dot(camera, camera) - 1.0;
	float h = b * b - c;
	if (h > 0.0) {
        valid = true;
        
        vec3 p = camera + (-b - sqrt(h)) * dir;
        pos = p.xz + iTime * vec2(0.005, 0.02);
	}

	return valid;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 screen = fragCoord.xy / iResolution.xy;
    
    vec3 camera = vec3(0.0, 1.2, 0.7);
    vec3 dir = getDir(screen);
    
    vec3 earth = vec3(0.0, 0.0, 0.0);
    vec2 position;
    if (getPosition(camera, dir, position)) {
        float geography = fbm(6.0 * position);

        float coast = 0.2 * pow(geography + 0.5, 50.0);
        float population = smoothstep(0.2, 0.6, fbm(2.0 * position) + coast);
        vec2 p = 40.0 * position;
        population *= (noise_3(p) + coast); p = m * p;
        population *= (noise_3(p) + coast); p = m * p;
        population *= (noise_3(p) + coast); p = m * p;
        population *= (noise_3(p) + coast); p = m * p;
        population *= (noise_3(p) + coast);
        population = smoothstep(0.0, 0.02, population);

        vec3 land = vec3(0.1 + 2.0 * population, 0.07 + 1.3 * population, population);
        vec3 water = vec3(0.0, 0.05, 0.1);
        vec3 ground = mix(land, water, smoothstep(0.49, 0.5, geography));

        vec2 wind = vec2(fbm(30.0 * position), fbm(60.0 * position));
        float weather = fbm(20.0 * (position + 0.03 * wind)) * (0.6 + 0.4 * noise(10.0 * position));

        float clouds = 0.8 * smoothstep(0.35, 0.45, weather) * smoothstep(-0.25, 1.0, fbm(wind));
        earth = mix(ground, vec3(0.3, 0.5, 0.5), clouds); 

        float lightning = 0.0;
        vec2 strike;
        if (getPosition(camera, getDir(hash21(iTime)), strike)) {
            vec2 diff = position - strike;
            lightning += clamp(1.0 - 1500.0 * dot(diff, diff), 0.0, 1.0);
        }
        lightning *= smoothstep(0.65, 0.75, weather);
        earth += lightning * vec3(1.0, 1.0, 1.0);
    }
    
    vec3 altitude = camera - dir * dot(camera, dir);
    float horizon = sqrt(dot(altitude, altitude));
    
    vec3 atmosphere = vec3(0.0, 0.13, 0.23);
    atmosphere = mix(atmosphere, vec3(0.04, 0.03, 0.1), smoothstep(0.996, 1.0204, horizon));
    atmosphere = mix(atmosphere, vec3(0.01, 0.0, 0.0), smoothstep(1.0, 1.0208, horizon));
    atmosphere = mix(atmosphere, vec3(0.02, 0.07, 0.1), smoothstep(1.008, 1.0215, horizon));
    atmosphere = mix(atmosphere, vec3(0.0, 0.0, 0.0), smoothstep(1.015, 1.018, horizon));

    horizon = clamp(pow(horizon, 20.0), 0.0, 1.0);
    fragColor = vec4(mix(earth, atmosphere, horizon), 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

